"use client";
import { imgUrl, marketUrlEndpoint } from "../../components/http";
import parse from "html-react-parser";
import Link from "next/link";
import useSWR from "swr";

const fetcher = (...args) => fetch(...args).then((response) => response.json());

function Page({ params }) {
  const { isLoading, data: post, error } = useSWR(marketUrlEndpoint, fetcher);
  if (isLoading) return <p>Data is loading</p>;
  if (error) return <p>Error is loading</p>;

  const _id = params.slug;
  //console.log(_id);

  const defaultHandler = (id) => {
    return post.filter((f) => f._id == _id);
  };

  const [posts] = defaultHandler();
 // console.log(posts);
  const {
    halls,
    body,
    title,
    profilePic,
    city,
    state,
    address,
    description,
    slug,
    id,
  } = posts;
 // console.log(title);

  return (
    <>
      <section className="py-10 bg-gray-100 sm:py-16 lg:py-24">
        <div className="px-4 mx-auto sm:px-6 lg:px-8 max-w-7xl">
          <div className="grid items-center grid-cols-1 gap-y-8 lg:grid-cols-2 gap-x-16 xl:gap-x-24">
            <div className="relative mb-12">
              <img
                className="w-full rounded-md"
                src={imgUrl + profilePic}
                alt={title}
              />

              <div className="absolute w-full max-w-xs px-4 -translate-x-1/2 sm:px-0 sm:max-w-sm left-1/2 -bottom-12">
                <div className="overflow-hidden bg-white rounded">
                  <div className="px-10 py-6">
                    <div className="flex items-center">
                      <p className="flex-shrink-0 text-1xl  text-blue-600 sm:text-2xl">
                        {city},{state}
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div>
              <div className="flex items-center justify-center w-16 h-16 bg-white rounded-full">
                <svg
                  className="w-8 h-8 text-orange-400"
                  xmlns="http://www.w3.org/2000/svg"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    stroke-linecap="round"
                    stroke-linejoin="round"
                    stroke-width="1.5"
                    d="M13 10V3L4 14h7v7l9-11h-7z"
                  />
                </svg>
              </div>
              <h2 className="mt-10 text-3xl font-bold leading-tight text-black sm:text-4xl lg:text-5xl lg:leading-tight">
                {title}
              </h2>
              <p className="mt-6 text-lg leading-relaxed text-gray-600">
                {description}
              </p>
              <div className="max-w-xl mx-auto mt-8 bg-white lg:mx-0 sm:bg-transparent lg:mt-12 rounded-xl">
                <div className="p-4 sm:p-2 sm:bg-white sm:border-2 sm:border-transparent sm:rounded-full sm:focus-within:border-orange-500 sm:focus-within:ring-1 sm:focus-within:ring-orange-500">
                  <div className="flex flex-col items-start sm:flex-row">
                    Address:
                    <p className="pl-6 text-sm font-medium text-black sm:text-lg">
                      {address} <br />
                    </p>
                  </div>
                  <div className="flex flex-col items-start sm:flex-row">
                    <p className="pl-6 text-sm font-medium text-black sm:text-lg">
                      <br />
                      Halls: {halls}
                    </p>
                  </div>
                </div>
              </div>
              <button
                type="submit"
                className="inline-flex items-center justify-center w-full px-4 py-4 mt-4 font-semibold text-white transition-all duration-200 bg-orange-500 border border-transparent rounded-full sm:w-auto sm:ml-4 sm:mt-0 hover:bg-orange-600 focus:bg-orange-600"
              >
                <Link
                  className="inline-block rounded-md border border-stroke px-7 py-[10px] text-sm font-medium text-body-color transition hover:border-primary hover:bg-primary hover:text-white dark:border-dark-3 dark:text-dark-6"
                  href={{
                    pathname: `/booking/`,
                    query: { title },
                  }}
                >
                  Book{" "}
                </Link>{" "}
              </button>
            </div>
          </div>
        </div>
      </section>
      <section class="py-10 bg-white sm:py-16 lg:py-24">
        <div class="max-w-6xl px-4 mx-auto sm:px-6 lg:px-8">
          {parse(body)}{" "}
          <div class="flow-root mt-12 sm:mt-16">
            <div class="divide-y divide-gray--200 -my-9"></div>
          </div>
        </div>
      </section>
    </>
  );
}

export default Page;
